import React from 'react';
import StyledButton from 'components/StyledButton';
import noInternetIcon from 'resources/images/no_internet.svg';
import useStyles from './styles';

type Props = {
    strings: object,
    checkForUpdates: () => {},
    onNeedSupport: () => {}
};

function NoInternet({ strings, checkForUpdates, onNeedSupport }: Props) {
    const classes = useStyles();
    return (
        <div className={classes.noInternetContainer}>
            <img
                className={classes.noInternetIcon}
                src={noInternetIcon}
                alt="No Internet"
            />
            <div className={classes.noInternetTitle}>
                {strings.no_internet_connection}
            </div>
            <div className={classes.noInternetSubtitle}>
                {strings.your_connection_was_lost}
            </div>
            <StyledButton onClick={checkForUpdates} btnSize="big">
                {strings.general_button_retry}
            </StyledButton>
            <div className={classes.needSupport} onClick={onNeedSupport}>
                {strings.general_link_need_support}
            </div>
        </div>
    );
}

export default NoInternet;
